@echo off

REM Read album info from text file
for /f "usebackq tokens=1,* delims==" %%A in ("album_info.txt") do (
    if /i "%%A"=="number" set "ALBNUM=%%B"
    if /i "%%A"=="artist" set "ARTIST=%%B"
    if /i "%%A"=="genre"  set "GENRE=%%B"
)

setlocal

REM Always run from the folder where this BAT lives
cd /d "%~dp0"

REM Get Year
for /f %%Y in ('wmic os get localdatetime ^| find "."') do set "dt=%%Y"
set "YEAR=%dt:~0,4%"

REM Album Folder
set "PARENT=%~dp0"
for %%I in ("%PARENT:~0,-1%") do set "PARENTNAME=%%~nxI"

REM Album name variable
set "MYALB=%ALBNUM% - %PARENTNAME% - %ARTIST% - %GENRE% - %YEAR%"

REM Create album folder and ENTER it
if not exist "%MYALB%" mkdir "%MYALB%"
cd /d "%MYALB%"

REM BASEDIR = original folder (where WAVs & large.png are)
set "BASEDIR=%~dp0"

REM Create text files INSIDE album folder
if not exist "sell beat.txt" echo.>"sell beat.txt"
if not exist "credits.txt" echo.>"credits.txt"

REM Resize large.png -> cover.jpg (300x300, highest JPEG quality) INTO album folder
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
  "$src = Join-Path '%BASEDIR%' 'large.png';" ^
  "$dst = Join-Path (Get-Location) 'cover.jpg';" ^
  "if (Test-Path $src) {" ^
  "  Add-Type -AssemblyName System.Drawing;" ^
  "  $img = [System.Drawing.Image]::FromFile($src);" ^
  "  $bmp = New-Object System.Drawing.Bitmap 300,300;" ^
  "  $gfx = [System.Drawing.Graphics]::FromImage($bmp);" ^
  "  $gfx.InterpolationMode = 'HighQualityBicubic';" ^
  "  $gfx.SmoothingMode = 'HighQuality';" ^
  "  $gfx.PixelOffsetMode = 'HighQuality';" ^
  "  $gfx.DrawImage($img, 0, 0, 300, 300);" ^
  "  $codec = [System.Drawing.Imaging.ImageCodecInfo]::GetImageEncoders() | Where-Object { $_.MimeType -eq 'image/jpeg' };" ^
  "  $params = New-Object System.Drawing.Imaging.EncoderParameters 1;" ^
  "  $params.Param[0] = New-Object System.Drawing.Imaging.EncoderParameter([System.Drawing.Imaging.Encoder]::Quality, 100L);" ^
  "  $bmp.Save($dst, $codec, $params);" ^
  "  $gfx.Dispose(); $bmp.Dispose(); $img.Dispose();" ^
  "} else {" ^
  "  Write-Host 'large.png not found';" ^
  "}"

REM Create video folder INSIDE album folder
if not exist "video" mkdir "video"

REM Create stream2.txt INSIDE album\video (using WAVs from BASEDIR)
powershell -NoProfile -ExecutionPolicy Bypass -Command ^
  "$ErrorActionPreference='SilentlyContinue';" ^
  "$srcDir = '%BASEDIR%';" ^
  "$out = Join-Path (Join-Path (Get-Location) 'video') 'stream2.txt';" ^
  "if (Test-Path $out) { Remove-Item $out -Force };" ^
  "$wmp = New-Object -ComObject 'WMPlayer.OCX';" ^
  "$tracks = Get-ChildItem -Path $srcDir -Filter '*.wav' -File | ForEach-Object {" ^
  "  $name = $_.BaseName;" ^
  "  if ($name -match '^\s*(\d+)') { $trackNum = [int]$matches[1] } else { $trackNum = 9999 }" ^
  "  $media = $wmp.newMedia($_.FullName);" ^
  "  $sec = [int][Math]::Round($media.duration);" ^
  "  if ($sec -lt 0) { $sec = 0 }" ^
  "  [PSCustomObject]@{ Track=$trackNum; Seconds=$sec }" ^
  "};" ^
  "$tracks | Sort-Object Track | ForEach-Object {" ^
  "  $m = [int]($_.Seconds / 60);" ^
  "  $s = [int]($_.Seconds %% 60);" ^
  "  Add-Content -Path $out -Value ('{0}:{1:00}' -f $m, $s) -Encoding UTF8;" ^
  "};" ^
  "Write-Host 'Done! Created video\stream2.txt';"

pause